/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class RadioInput
extends AbstractInput {
    private static final Map<String, List<RadioInput>> groups = new HashMap<String, List<RadioInput>>();
    private String groupId = null;
    private boolean focus = false;
    private Button button = null;
    private Object value = null;
    private boolean enabled = true;

    public RadioInput(String groupId, Object value) {
        this.groupId = groupId;
        this.value = value;
        List<RadioInput> group = groups.get(this.groupId);
        if (group == null) {
            group = new LinkedList<RadioInput>();
            groups.put(this.groupId, group);
        }
        group.add(this);
    }

    public static void select(String groupId, Object value) {
        List<RadioInput> list = groups.get(groupId);
        for (RadioInput input : list) {
            if (input.button == null || input.button.isDisposed()) continue;
            try {
                input.button.setSelection(BeanUtil.equals((Object)value, (Object)input.value));
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to compare objects", (Throwable)re);
            }
            input.button.redraw();
        }
    }

    public static Object getValue(String groupId) {
        List<RadioInput> list = groups.get(groupId);
        for (RadioInput input : list) {
            if (input.button == null || input.button.isDisposed() || !input.button.getSelection()) continue;
            return input.value;
        }
        return null;
    }

    @Override
    public Control getControl() {
        if (this.button != null) {
            return this.button;
        }
        this.button = new Button(this.getParent(), 16);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.button.setToolTipText(tooltip.toString());
        }
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = false;
                RadioInput.select(RadioInput.this.groupId, RadioInput.this.value);
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                groups.remove(RadioInput.this.groupId);
            }
        });
        String name = this.getName();
        if (name != null) {
            this.button.setText(name);
        }
        if (this.focus) {
            this.button.setFocus();
        }
        this.button.setEnabled(this.enabled);
        if (this.isMandatory() && Application.getConfig().getMandatoryLabel()) {
            this.button.setForeground(Color.ERROR.getSWTColor());
        }
        return this.button;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null && this.button != null && !this.button.isDisposed()) {
            this.button.setText(name);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setFocus();
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        if (this.button == null || this.button.isDisposed()) {
            return this.enabled;
        }
        return this.button.getEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(enabled);
        }
    }

    @Override
    protected void update() throws OperationCanceledException {
    }
}

